ALTER TABLE ADRMGT.ADR_PARAMETER_H
  DROP CONSTRAINT ADR_PARAMETER_H_ID_PK;

ALTER TABLE ADRMGT.ADR_PARAMETER_H ADD (
  CONSTRAINT ADR_PARAMETER_H_ID_PK
  PRIMARY KEY
  (ADR_PARAMETER_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.ADR_PARAMETER
  DROP CONSTRAINT ADR_PARAMETER_ID_PK;

ALTER TABLE ADRMGT.ADR_PARAMETER ADD (
  CONSTRAINT ADR_PARAMETER_ID_PK
  PRIMARY KEY
  (ADR_PARAMETER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.ADR_PARAMETER
  DROP CONSTRAINT ADR_PARAM_INACTIVE_FLAG_CK;

ALTER TABLE ADRMGT.ADR_PARAMETER ADD (
  CONSTRAINT ADR_PARAM_INACTIVE_FLAG_CK
  CHECK (Inactive_flag IN ('Y','N'))
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.ADR_PARAMETER
  DROP CONSTRAINT ADR_PARAM_TYPE_CK;

ALTER TABLE ADRMGT.ADR_PARAMETER ADD (
  CONSTRAINT ADR_PARAM_TYPE_CK
  CHECK (Type IN ('NUMERIC','ALPHANUMERIC'))
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.ADR_PARAMETER
  DROP CONSTRAINT ADR_PARAM_UNITS_CK;

ALTER TABLE ADRMGT.ADR_PARAMETER ADD (
  CONSTRAINT ADR_PARAM_UNITS_CK
  CHECK (Unit IN ('YEAR','MONTH','WEEK','DAY','HOUR',                      'MINUTE','COUNT','DATE','TIME'))
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.CCR
  DROP CONSTRAINT CCR_DEP_FK;


ALTER TABLE ADRMGT.CCR ADD (
  CONSTRAINT CCR_DEP_FK 
  FOREIGN KEY (DEPLOYMENT_ID) 
  REFERENCES ADRMGT.DEPLOYMENT (DEPLOYMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.CCR_H
  DROP CONSTRAINT CCR_H_ID;

ALTER TABLE ADRMGT.CCR_H ADD (
  CONSTRAINT CCR_H_ID
  PRIMARY KEY
  (CCR_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.CCR
  DROP CONSTRAINT CCR_ID_PK;

ALTER TABLE ADRMGT.CCR ADD (
  CONSTRAINT CCR_ID_PK
  PRIMARY KEY
  (CCR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.CCR
  DROP CONSTRAINT CCR_NUMBER_UK;

ALTER TABLE ADRMGT.CCR ADD (
  CONSTRAINT CCR_NUMBER_UK
  UNIQUE (CCR_NUMBER)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.CCR
  DROP CONSTRAINT CCR_REL_FK;


ALTER TABLE ADRMGT.CCR ADD (
  CONSTRAINT CCR_REL_FK 
  FOREIGN KEY (RELEASE_ID) 
  REFERENCES ADRMGT.RELEASE (RELEASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.CCR_H
  DROP CONSTRAINT CCR_TRANS_CHK;

ALTER TABLE ADRMGT.CCR_H ADD (
  CONSTRAINT CCR_TRANS_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.ADR_USER_CONTACT_H
  DROP CONSTRAINT CONTACT_ID_H_PK;

ALTER TABLE ADRMGT.ADR_USER_CONTACT_H ADD (
  CONSTRAINT CONTACT_ID_H_PK
  PRIMARY KEY
  (ADR_USER_CONTACT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.ADR_USER_CONTACT
  DROP CONSTRAINT CONTACT_ID_PK;

ALTER TABLE ADRMGT.ADR_USER_CONTACT ADD (
  CONSTRAINT CONTACT_ID_PK
  PRIMARY KEY
  (ADR_USER_CONTACT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.DEPLOYMENT_H
  DROP CONSTRAINT DEPLOYMENT_H_ID_PK;

ALTER TABLE ADRMGT.DEPLOYMENT_H ADD (
  CONSTRAINT DEPLOYMENT_H_ID_PK
  PRIMARY KEY
  (DEPLOYMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.DEPLOYMENT
  DROP CONSTRAINT DEPLOYMENT_ID_PK;

ALTER TABLE ADRMGT.DEPLOYMENT ADD (
  CONSTRAINT DEPLOYMENT_ID_PK
  PRIMARY KEY
  (DEPLOYMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.DEPLOYMENT_H
  DROP CONSTRAINT DEP_TRANS_CHK;

ALTER TABLE ADRMGT.DEPLOYMENT_H ADD (
  CONSTRAINT DEP_TRANS_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.RELEASE_H
  DROP CONSTRAINT RELEASE_ID_H_PK;

ALTER TABLE ADRMGT.RELEASE_H ADD (
  CONSTRAINT RELEASE_ID_H_PK
  PRIMARY KEY
  (RELEASE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.RELEASE
  DROP CONSTRAINT RELEASE_ID_PK;

ALTER TABLE ADRMGT.RELEASE ADD (
  CONSTRAINT RELEASE_ID_PK
  PRIMARY KEY
  (RELEASE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.RELEASE
  DROP CONSTRAINT RELEASE_NUMBER_UK;

ALTER TABLE ADRMGT.RELEASE ADD (
  CONSTRAINT RELEASE_NUMBER_UK
  UNIQUE (RELEASE_NUMBER)
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.RELEASE_H
  DROP CONSTRAINT REL_TRANS_CHK;

ALTER TABLE ADRMGT.RELEASE_H ADD (
  CONSTRAINT REL_TRANS_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.RELEASE
  DROP CONSTRAINT RLS_DPLMNT_FK;


ALTER TABLE ADRMGT.RELEASE ADD (
  CONSTRAINT RLS_DPLMNT_FK 
  FOREIGN KEY (DEPLOYMENT_ID) 
  REFERENCES ADRMGT.DEPLOYMENT (DEPLOYMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  DEPLOYMENT_ID NULL;

ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  DEPLOYMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  TICKET_NUMBER NULL;

ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  TICKET_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADRMGT.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR MODIFY 
  CCR_ID NULL;

ALTER TABLE ADRMGT.CCR MODIFY 
  CCR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR MODIFY 
  CCR_NUMBER NULL;

ALTER TABLE ADRMGT.CCR MODIFY 
  CCR_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADRMGT.CCR MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.CCR MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADRMGT.CCR MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADRMGT.CCR MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADRMGT.CCR MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  DEPLOYMENT_H_ID NULL;

ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  DEPLOYMENT_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  DEPLOYMENT_ID NULL;

ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  DEPLOYMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADRMGT.DEPLOYMENT_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR_H MODIFY 
  CCR_H_ID NULL;

ALTER TABLE ADRMGT.CCR_H MODIFY 
  CCR_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR_H MODIFY 
  CCR_ID NULL;

ALTER TABLE ADRMGT.CCR_H MODIFY 
  CCR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR_H MODIFY 
  CCR_NUMBER NULL;

ALTER TABLE ADRMGT.CCR_H MODIFY 
  CCR_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADRMGT.CCR_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.CCR_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADRMGT.CCR_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADRMGT.CCR_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADRMGT.CCR_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.CCR_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADRMGT.CCR_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE MODIFY 
  RELEASE_ID NULL;

ALTER TABLE ADRMGT.RELEASE MODIFY 
  RELEASE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE MODIFY 
  RELEASE_NUMBER NULL;

ALTER TABLE ADRMGT.RELEASE MODIFY 
  RELEASE_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADRMGT.RELEASE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.RELEASE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADRMGT.RELEASE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADRMGT.RELEASE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADRMGT.RELEASE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RELEASE_H_ID NULL;

ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RELEASE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RELEASE_ID NULL;

ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RELEASE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RELEASE_NUMBER NULL;

ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RELEASE_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADRMGT.RELEASE_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.JOB_PROCESS_ERRS MODIFY 
  JOB_PROCESS_ERRS_ID NULL;

ALTER TABLE ADRMGT.JOB_PROCESS_ERRS MODIFY 
  JOB_PROCESS_ERRS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.JOB_PROCESS_ERRS MODIFY 
  JOB_NAME NULL;

ALTER TABLE ADRMGT.JOB_PROCESS_ERRS MODIFY 
  JOB_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.JOB_PROCESS_ERRS MODIFY 
  JOB_ERROR_DATE NULL;

ALTER TABLE ADRMGT.JOB_PROCESS_ERRS MODIFY 
  JOB_ERROR_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.JOB_PROCESS_ERRS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.JOB_PROCESS_ERRS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.JOB_PROCESS_LOGS MODIFY 
  JOB_PROCESS_LOGS_ID NULL;

ALTER TABLE ADRMGT.JOB_PROCESS_LOGS MODIFY 
  JOB_PROCESS_LOGS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.JOB_PROCESS_LOGS MODIFY 
  JOB_NAME NULL;

ALTER TABLE ADRMGT.JOB_PROCESS_LOGS MODIFY 
  JOB_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.JOB_PROCESS_LOGS MODIFY 
  JOB_LOG_DATE NULL;

ALTER TABLE ADRMGT.JOB_PROCESS_LOGS MODIFY 
  JOB_LOG_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.JOB_PROCESS_LOGS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.JOB_PROCESS_LOGS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  ADR_PARAMETER_ID NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  ADR_PARAMETER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  TYPE NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  TYPE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  PARAMETER_NAME NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  PARAMETER_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  DESCRIPTION NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  DESCRIPTION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  VALUE NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  VALUE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  INACTIVE_FLAG NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  INACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  ADR_PARAMETER_H_ID NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  ADR_PARAMETER_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  ADR_PARAMETER_ID NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  ADR_PARAMETER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADRMGT.ADR_PARAMETER_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  ADR_USER_CONTACT_ID NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  ADR_USER_CONTACT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  ADR_USER_CONTACT_H_ID NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  ADR_USER_CONTACT_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  ADR_USER_CONTACT_ID NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  ADR_USER_CONTACT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADRMGT.ADR_USER_CONTACT_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
